---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：90-pandas API on Spark

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **pandas API互換性の詳細範囲**：missing/配下の未実装API一覧の確認が必要
  2. **内部Spark DataFrame変換の具体的なメカニズム**：internal.pyの詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `python/pyspark/pandas/__init__.py` 18-100行目
- E-02: `python/pyspark/pandas/frame.py` 18-80行目
- E-03: `python/pyspark/pandas/series.py`
- E-04: `python/pyspark/pandas/groupby.py`
- E-05: `python/pyspark/pandas/indexes/base.py`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` 90行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | versionadded 3.2.0 | E-01 (19行目) | ○ |
| C-02 | require_minimum_pandas_version()で検証 | E-01 (33行目) | ○ |
| C-03 | require_minimum_pyarrow_version()で検証 | E-01 (34行目) | ○ |
| C-04 | SPARK_TESTINGモードで警告終了 | E-01 (36-39行目) | ○ |
| C-05 | __all__でパブリックAPI定義 | E-01 (51-78行目) | ○ |
| C-06 | read_csv, read_parquet, sql等のI/O API | E-01 (52-54行目) | ○ |
| C-07 | DataFrame, Series, Index, MultiIndex等の提供 | E-01 (42-49行目) | ○ |
| C-08 | _auto_patch_spark()で初期化 | E-01 (81行目) | ○ |
| C-09 | PYSPARK_PANDAS_USAGE_LOGGERで使用状況ログ | E-01 (86行目) | ○ |
| C-10 | KOALAS_USAGE_LOGGERとの後方互換 | E-01 (86行目) | ○ |
| C-11 | frame.pyがSpark DataFrameのラッパー | E-02 (20行目) | ○ |
| C-12 | NumPy/pandas/PySpark SQL importの活用 | E-02 (54-80行目) | ○ |
| C-13 | pandas_udfの利用 | E-02 (74行目) | ○ |
| C-14 | MissingPandasLikeGeneralFunctionsスタブ | E-01 (28行目) | ○ |
| C-15 | pandas API互換性の詳細範囲 | **根拠なし** | △ |
| C-16 | internal.pyの内部Spark DataFrame変換メカニズム | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- pandas API互換性の網羅的な一覧（サポート済み/未サポートの分類）
  - 候補：`python/pyspark/pandas/missing/`配下の各ファイル
- internal.pyのSpark DataFrame管理メカニズムの詳細
  - 候補：`python/pyspark/pandas/internal.py`の全体読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パッケージ構造とパブリックAPIはソースコードから確認済み
- 1: 中リスク - pandasとの正確な互換性範囲は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] frame.pyのDataFrameクラスの主要メソッドを確認
- [ ] internal.pyのSpark DataFrame管理を確認
- [ ] missing/配下の未実装API一覧を確認
- [ ] from_pandas/to_pandasの変換パフォーマンスを確認
